<?php
/*
$Id: sr_functions.php,v 1.6 2004/06/08 06:47:21 josheli Exp $
*/

//////////////////////////////////////
//
//  DO NOT ECHO ANYTHING IN THIS FILE
//  ALWAYS RETURN A STRING IF NEEDED
//
//////////////////////////////////////

/******
This function is used to calculate and display a batting average
*******/

function batting_avg($hits, $at_bats){

 if($at_bats!=0){
  $avg=$hits/$at_bats;
  $number=number_format($avg,3);
  $ba=str_replace("0.", ".", $number);
 }
 else{
  $ba="--";
 }
  return $ba;
}

/******
This function is used to calculate and display an onbase percentage
*******/

function onbase_percentage($at_bats, $hits, $walks, $hit_by_pitches, $sac_flys){
//Formula: (Hits + Walks + Times Hit by Pitch) / (At Bats + Walks + Times Hit by Pitch + Sacrifice Flies)

  $divisor=$at_bats + $walks + $hit_by_pitches + $sac_flys;
  if($divisor == 0) return '--';

  $obp= ($hits + $walks + $hit_by_pitches) / $divisor;

  //$number=number_format($obp,3);
   $number=sprintf("%01.3f", round($obp,3));
  $op=str_replace("0.", ".", $number);

  return $op;

}

/******
This function is used to calculate and display a slugging percentage
*******/

function slugging_percentage($at_bats, $singles, $doubles, $triples, $home_runs) {

if ($at_bats!=0){
 $total_bases=$singles+($doubles*2)+($triples*3)+($home_runs*4);
 $sp=$total_bases/$at_bats;

 $number=number_format($sp,3);
 $slug=str_replace("0.", ".", $number);
}
else {
 $slug="--";
}

return $slug;

}

/***********
This function will undo htmlspecialchars()
***********/

function undospecialchars($htmltext){

	$plaintext=str_replace('&amp;', '&', str_replace('&quot;', "\"", str_replace('&lt;', '<', str_replace('&gt;', '>', $htmltext))));

	return $plaintext;
}


/***********
This function outputs the menu
***********/

function showmenu() {

//$url = parse_url($_SERVER['PHP_SELF']);
$filename = basename($_SERVER['PHP_SELF'], '.php');

	$menu='<p class="mmenu"><a href="sr_index.php" class="mmenu">Main Menu</a> | ';
	
	switch ($filename) {
		case 'view_stats':
			$menu.='View Stats | <a href="select_game.php?action=new" class="mmenu">New Stats</a> | <a href="select_game.php?action=update" class="mmenu">Update Stats</a> | <a href="manage_schedule.php" class="mmenu">Manage Schedule</a>';
			break;
		case 'select_game':
			if($_GET['action'] == 'new'){
				$menu.='<a href="view_stats.php" class="mmenu">View Stats</a> | New Stats | <a href="select_game.php?action=update" class="mmenu">Update Stats</a> | <a href="manage_schedule.php" class="mmenu">Manage Schedule</a>';
			}
			else {
				$menu.='<a href="view_stats.php" class="mmenu">View Stats</a> | <a href="select_game.php?action=new" class="mmenu">New Stats</a> | Update Stats | <a href="manage_schedule.php" class="mmenu">Manage Schedule</a>';
			}
			break;
		case 'manage_schedule':
			$menu .= '<a href="view_stats.php" class="mmenu">View Stats</a> | <a href="select_game.php?action=new" class="mmenu">New Stats</a> | <a href="select_game.php?action=update" class="mmenu">Update Stats</a> | Manage Schedule';
			break;

		default:
			$menu='<p class="mmenu"><a href="sr_index.php" class="mmenu">Main Menu</a> | <a href="view_stats.php" class="mmenu">View Stats</a> | <a href="select_game.php?action=new" class="mmenu">New Stats</a> | <a href="select_game.php?action=update" class="mmenu">Update Stats</a> | <a href="manage_schedule.php" class="mmenu">Manage Schedule</a>';
			break;
	}
	$menu .= ' | <a href="logout.php" class="mmenu">Logout</a></p>';

return $menu;
}

/***********
This function outputs a META refresh redirect (on unsuccessful logins, db connect errors...)
Use it in place of header() when you've already sent output to the browser
***********/
function show_redirect($msg, $delay='6') {

	$redirect = '<center>'.$msg.'</center>.<META HTTP-EQUIV=Refresh CONTENT="'.$delay.'; URL='.STATRAT_BASE_URL.'">';
	
	return $redirect;
}

/*******
********/
function getRequestVars() {
  $r = array();
  foreach($_REQUEST as $name => $value){
    if(is_array($value)){
      $sub=array();
      foreach($value as $n=>$v){
        $sub[$n] = cleanVar($v);
      }
      $r[$name] = $sub;
    }
    else {
      $r[$name] = cleanVar($value);      
    }
  }
  return $r;
}

/*******
********/
function cleanVar($var) {
  return trim(strip_tags($var));
}
/*******
array('value'=>'display'), default value
********/
function buildSelectOpts($array, $default='') {
  $opts = '';
  foreach($array as $value => $display){
		if($value == $default){
			$selected = ' selected';
		}
		else {
			$selected = '';
		}
		$opts .= '<option value="'.$value.'"'.$selected.'>'.$display."</option>\n";
	}
	return $opts;
}

function srMakeDate($month,$day,$year,$hour,$minute){
	$year = (strlen($year)==2) ? '20'.$year: $year;
  $month = (strlen($month)==1) ? '0'.$month : $month;
  $day = (strlen($day)==1) ? '0'.$day : $day;
	$hour = (strlen($hour)==1) ? '0'.$hour : $hour;
  $minute = (strlen($minute)==1) ? '0'.$minute : $minute;
	if(!checkdate(intval($month), intval($day), intval($year)) || !in_array($hour,range(0,24)) ||!in_array($minute,range(0,59))){
		return false;
	}
	return compact('year','month','day','hour','minute');
}
?>