# $Id: statrat.sql,v 1.6 2004/06/07 19:19:24 josheli Exp $
# SQL for statrat.
# 

# --------------------------------------------------------

#
# Table structure for table `sr_game_data`
#
# Creation: May 07, 2003 at 04:02 PM
# Last update: Jan 17, 2004 at 03:46 AM
#

CREATE TABLE `sr_game_data` (
  `gd_game` int(11) NOT NULL default '0',
  `gd_lineup` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`gd_game`)
) TYPE=MyISAM COMMENT='Stores data in case of entry interruption';

# --------------------------------------------------------

#
# Table structure for table `stat_batting`
#
# Creation: Aug 21, 2003 at 06:13 PM
# Last update: Jan 14, 2004 at 02:31 AM
# Last check: Aug 21, 2003 at 06:13 PM
#

CREATE TABLE `stat_batting` (
  `player_id` tinyint(4) NOT NULL default '0',
  `game_number` tinyint(4) NOT NULL default '0',
  `plate_appearances` tinyint(4) NOT NULL default '0',
  `at_bats` tinyint(4) NOT NULL default '0',
  `singles` tinyint(4) NOT NULL default '0',
  `doubles` tinyint(4) NOT NULL default '0',
  `triples` tinyint(4) NOT NULL default '0',
  `home_runs` tinyint(4) NOT NULL default '0',
  `walks` tinyint(4) NOT NULL default '0',
  `strikeouts` tinyint(4) NOT NULL default '0',
  `runs` tinyint(4) NOT NULL default '0',
  `steals` tinyint(4) NOT NULL default '0',
  `rbi` tinyint(4) NOT NULL default '0',
  `sac_flys` tinyint(4) NOT NULL default '0',
  `sac_bunts` tinyint(4) NOT NULL default '0',
  `hit_by_pitch` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`player_id`,`game_number`),
  KEY `index_player` (`player_id`),
  KEY `index_game` (`game_number`)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `stat_players`
#
# Creation: Aug 21, 2003 at 06:14 PM
# Last update: Jan 20, 2004 at 10:16 PM
#

CREATE TABLE `stat_players` (
  `player_id` int(11) NOT NULL auto_increment,
  `last_name` varchar(25) NOT NULL default '',
  `first_name` varchar(25) default '',
  `jersey_number` tinyint(4) default '0',
  `position` varchar(10) default '',
  `email` varchar(25) default '',
  `phone_number` varchar(10) default '',
  `team_id` int(11) default '0',
  PRIMARY KEY  (`player_id`)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `stat_schedule`
#
# Creation: Aug 21, 2003 at 09:13 PM
# Last update: Jan 17, 2004 at 03:46 AM
#

CREATE TABLE `stat_schedule` (
  `team_score` tinyint(4) default '0',
  `opponent_score` tinyint(4) default '0',
  `game_number` tinyint(4) NOT NULL auto_increment,
  `game_opponent` varchar(25) NOT NULL default '',
  `game_location` varchar(25) default '',
  `game_time` time default '00:00:00',
  `game_date` date default '0000-00-00',
  `home_visitor` char(1) default NULL,
  `division` char(1) default NULL,
  `status` varchar(32) default 'Scheduled',
  `season_id` int(11) default '0',
  `home_team_id` int(11) default '0',
  `home_team_score` tinyint(4) default '0',
  `visit_team_id` int(11) default '0',
  `visit_team_score` tinyint(4) default '0',
  PRIMARY KEY  (`game_number`)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `stat_seasons`
#
# Creation: Jan 20, 2004 at 10:38 PM
# Last update: Jan 20, 2004 at 11:22 PM
#

CREATE TABLE `stat_seasons` (
  `season_id` int(11) NOT NULL auto_increment,
  `season_name` varchar(35) NOT NULL default '',
  `league_id` int(11) NOT NULL default '0',
  `start_date` date NULL,
  `end_date` date NULL,
  PRIMARY KEY  (`season_id`)
) TYPE=MyISAM;

INSERT INTO stat_seasons (season_name,start_date,end_date) VALUES ('Default Season', now(), DATE_ADD(now(),INTERVAL 6 MONTH));

# --------------------------------------------------------

#
# Table structure for table `stat_team`
#
# Creation: Jun 11, 2003 at 03:01 AM
# Last update: Jan 20, 2004 at 09:38 PM
#

CREATE TABLE `stat_team` (
  `team_id` int(11) NOT NULL auto_increment,
  `team_name` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`team_id`)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `stat_users`
#
# Creation: May 06, 2003 at 10:41 PM
# Last update: May 06, 2003 at 10:41 PM
#

CREATE TABLE `stat_users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(32) NOT NULL default '',
  `pass` varchar(32) NOT NULL default '',
  `level` tinyint(4) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `login` (`login`)
) TYPE=MyISAM;

INSERT INTO stat_users (login, pass) values ('admin', PASSWORD('changeme'));